<?php
/**
 * @package     Joomla - > Site and Administrator payment info
 * @subpackage  com_eshop pay shepa plugins
 * @copyright   trangell team => https://trangell.com
 * @copyright   Copyright (C) 2017 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die();
require_once JPATH_SITE . '/components/com_eshop/plugins/payment/os_trangell_inputcheck.php';

class os_shepa extends os_payment
{

	public function __construct($params) {
        $config = array(
            'type' => 0,
            'show_card_type' => false,
            'show_card_holder_name' => false
        );
        $this->setData('merchant_id',$params->get('merchant_id'));
        
        parent::__construct($params, $config);
	}
    function curl_post($url, $params)
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
        ]);
        $res = curl_exec($ch);
        curl_close($ch);

        return $res;
    }
	public function processPayment($data) {
		$app	= JFactory::getApplication();
		$Amount = $data['total']/10; // Toman 
		$Description = 'خرید محصول از فروشگاه   '. EshopHelper::getConfigValue('store_owner'); 
		$Email = $data['email']; 
		$Mobile = $data['telephone']; 
		$CallbackURL = JURI::root().'index.php?option=com_eshop&task=checkout.verifyPayment&payment_method=os_shepa&id='.$data['order_id']; 
			
		try {



            $data =[
                    'api' => $this->data['merchant_id'],
                    'amount' => $Amount,
                    //'amount' => 100000,
                    'callback' => JURI::root().'index.php?option=com_eshop&task=checkout.verifyPayment&payment_method=os_shepa&id='.$data['order_id'],
                    'mobile' => $data['telephone'],
                    'email' => $Email,
                    'description' => $Description,
				];
            $url = 'https://merchant.shepa.com/api/v1/token';
            if($this->data['merchant_id'] == 'sandbox') {
                $url = 'https://sandbox.shepa.com/api/v1/token';
            }
			$resultStatus = json_decode($this->curl_post($url , $data));

			if (!empty($resultStatus) && !empty($resultStatus->success)) {
					Header('Location: '.$resultStatus->result->url);
				//Header('Location: https://sandbox.shepa.com/pg/StartPay/'.$result->Authority); // for local/
			} else {
				echo'خظا: '.implode(",", $resultStatus->error);
			}
		}
		catch(Exception $e) {
			$msg= $this->getGateMsg('error'); 
			$app	= JFactory::getApplication();
			$link = JRoute::_(JUri::root().'index.php?option=com_eshop&view=checkout&layout=cancel',false);
			$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
		}
		
	}

	protected function validate($id) {

		$app	= JFactory::getApplication();		
		$allData = EshopHelper::getOrder(intval($id)); //get all data
		//$mobile = $allData['telephone'];
		$jinput = JFactory::getApplication()->input;
		$Token = $jinput->get->get('token');
		$status = $jinput->get->get('status', '', 'STRING');
		
		$this->logGatewayData(' OrderID: ' . $id . 'Token:' . $Token . 'status:'.$status. 'OrderTime:'.time() );
		
		if (checkHack::checkString($status)){

			if ($status == 'success') {
				try {
                    $data =[
                            'api' => $this->data['merchant_id'],
                            'token' => $Token,
                            'amount' => round($allData->total/10,4),
                            //'amount' => 100000,
						];
                    $url = 'https://merchant.shepa.com/api/v1/verify';
                    if($this->data['merchant_id'] == 'sandbox') {
                        $url = 'https://sandbox.shepa.com/api/v1/verify';
                    }
                    $resultStatus = json_decode($this->curl_post($url , $data));
                    if (!empty($resultStatus) && !empty($resultStatus->success)) {
						$this->onPaymentSuccess($id, $resultStatus->result->refid);
						$msg= $this->getGateMsg($resultStatus); 
						$link = JRoute::_(JUri::root().'index.php?option=com_eshop&view=checkout&layout=complete',false);
						$app->redirect($link, '<h2>'.$msg.'</h2>'.'<h3>'. $resultStatus->result->refid .'شماره پیگری ' .'</h3>' , $msgType='Message');
						return true;
					} 
					else {
						$msg= implode(",", $resultStatus->error);
						$link = JRoute::_(JUri::root().'index.php?option=com_eshop&view=checkout&layout=cancel',false);
						$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
						return false;
					}
				}
				catch(Exception $e) {
					$msg= $this->getGateMsg('error'); 
					$app	= JFactory::getApplication();
					$link = JRoute::_(JUri::root().'index.php?option=com_eshop&view=checkout&layout=cancel',false);
					$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
					return false;
				}
		}
		else {
			$msg= $this->getGateMsg(intval(17)); 
			$app	= JFactory::getApplication();
			$link = JRoute::_(JUri::root().'index.php?option=com_eshop&view=checkout&layout=cancel',false);
			$app->redirect($link, '<h2>'.$msg.'</h2>', $msgType='Error'); 
			return false;	
		}
	}
	else {
		$msg= $this->getGateMsg('hck2'); 
		$app	= JFactory::getApplication();
		$link = JRoute::_(JUri::root().'index.php?option=com_eshop&view=checkout&layout=cancel',false);
		$app->redirect($link, '<h2>'.$msg.'</h2>' , $msgType='Error'); 
		return false;	
	}
	
}

	public function verifyPayment() {
		$jinput = JFactory::getApplication()->input;
		$id = $jinput->get->get('id', '0', 'INT');
		$row = JTable::getInstance('Eshop', 'Order');
		$row->load($id);
		if ($row->order_status_id == EshopHelper::getConfigValue('complete_status_id'))
				return false;
				
		$this->validate($id);
	}

	public function getGateMsg ($msgId) {

		return "پرداخت با مشکل مواجه شده است";
	}
}
