(() => {
    const shepa_settings = window.wc.wcSettings.getSetting("shepa_ir_data", {});
    const shepa_Content = () => {
        return window.wp.htmlEntities.decodeEntities(
            shepa_settings.description || "شبکه پرداخت آنلاین"
        );
    };
    const shepa_title = Object(window.wp.element.createElement)(
        () => window.wp.htmlEntities.decodeEntities(shepa_settings.title || "shepa")
    );
    const shepa_logo = Object(window.wp.element.createElement)("img", {
        src: shepa_settings.img,
        alt: window.wp.htmlEntities.decodeEntities(shepa_settings.title),
    });

    const shepa_label = wp.element.createElement("span", null, [
        shepa_logo,
        shepa_title,
    ]);

    const shepa_Block_Gateway = {
        name: "shepa_ir",
        label: shepa_label,
        content: Object(window.wp.element.createElement)(shepa_Content, null),
        edit: Object(window.wp.element.createElement)(shepa_Content, null),
        canMakePayment: () => true,
        ariaLabel: shepa_settings.title,
        supports: {
            features: shepa_settings.supports,
        },
    };
    window.wc.wcBlocksRegistry.registerPaymentMethod(shepa_Block_Gateway);
})();
