<?php
/*
Plugin Name:Shepa Gateway
Plugin URI: https://shepa.com/
Description: Extends WooCommerce with an shepa gateway.
Version: 1.92
Author: AmirRezai, Amir Mahmoodtork
Author URI: https://shepa.com/
Requires PHP: 7.4
*/

// Exit if accessed directly.
if (!defined('ABSPATH')) {
    exit;
}

/**
 * Shepa Payment gateway plugin class.
 *
 * @class WC_Shepa_Dollar_Payments
 */
class WC_Shepa_Dollar_Payments
{
    /**
     * Plugin bootstrapping.
     */
    public static function init()
    {
        add_action('plugins_loaded', [
            __CLASS__, 'includes'
        ], 1);
        add_action('before_woocommerce_init', [__CLASS__, 'declare_cart_checkout_blocks_compatibility']);
        add_filter("woocommerce_payment_gateways", [__CLASS__, 'add_gateway']);
        add_action("woocommerce_blocks_loaded", [__CLASS__, 'shepa_gateway_woocommerce_blocks_support']);
    }

    /**
     * Add the Dummy Payment gateway to the list of available gateways.
     *
     * @param array
     */
    public static function add_gateway($gateways)
    {
        $gateways[] = 'WC_Gateway_Shepa';
        $gateways[] = 'WC_Gateway_Shepa_Ir';
        $gateways[] = 'WC_Gateway_Shepa_Perfect';
        return $gateways;
    }

    /**
     * Plugin includes.
     */
    public static function includes()
    {

        // Make the WC_Gateway_Shepa class available.
        if (class_exists('WC_Payment_Gateway')) {
            require_once 'includes/class_wc_gateway_shepa.php';
        }
        if (class_exists('WC_Payment_Gateway')) {
            require_once 'includes/class_wc_gateway_shepa_ir.php';
        }
        // if (class_exists('WC_Payment_Gateway')) {
        //     require_once 'includes/class_wc_gateway_shepa_perfect.php';
        // }
    }

    public static function declare_cart_checkout_blocks_compatibility()
    {
        // Check if the required class exists
        if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
            // Declare compatibility for 'cart_checkout_blocks'
            \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('cart_checkout_blocks', self::plugin_abspath(), true);
        }
    }

    /**
     * Plugin url.
     *
     * @return string
     */
    public static function plugin_url()
    {
        return untrailingslashit(plugins_url('/', __FILE__));
    }

    /**
     * Plugin url.
     *
     * @return string
     */
    public static function plugin_abspath()
    {
        return trailingslashit(plugin_dir_path(__FILE__));
    }

    /**
     * Registers WooCommerce Blocks integration.
     *
     */
    public static function shepa_gateway_woocommerce_blocks_support()
    {
        if (class_exists('Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType')) {
            require_once 'includes/blocks/class_wc_shepa_payments_block.php';
            require_once 'includes/blocks/class_wc_shepa_ir_payments_block.php';
            require_once 'includes/blocks/class_wc_shepa_perfect_payments_block.php';
            add_action(
                'woocommerce_blocks_payment_method_type_registration',
                function (Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
                    $payment_method_registry->register(new ShepaMethod());
                }
            );
            add_action(
                'woocommerce_blocks_payment_method_type_registration',
                function (Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
                    $payment_method_registry->register(new ShepaIrMethod());
                }
            );
            add_action(
                'woocommerce_blocks_payment_method_type_registration',
                function (Automattic\WooCommerce\Blocks\Payments\PaymentMethodRegistry $payment_method_registry) {
                    $payment_method_registry->register(new ShepaPerfectMethod());
                }
            );
        }
    }
}

WC_Shepa_Dollar_Payments::init();
