<?php

use Automattic\WooCommerce\Blocks\Payments\Integrations\AbstractPaymentMethodType;

class ShepaMethod extends AbstractPaymentMethodType
{
    protected $name = "shepa";
    private $gateway;

    /**
     * An instance of the Asset Api
     *
     * @var Api
     */
    // private $asset_api;

    // public function __construct($asset_api)
    // {
    //     $this->asset_api = $asset_api;
    // }
    public function initialize()
    {

        $this->settings = get_option('woocommerce_shepa_settings', []);
        $this->gateway = new WC_Gateway_Shepa();
    }

    public function is_active()
    {

        return $this->gateway->is_available();
    }

    public function get_payment_method_script_handles()
    {
        $script_path = '/assets/js/frontend/blocks.js';
        wp_register_script(
            'shepa_gateway-blocks-integration',
            WC_Shepa_Dollar_Payments::plugin_url() . $script_path,
            [
                'wc-blocks-registry',
                'wc-settings',
                'wp-element',
                'wp-html-entities',
                'wp-i18n',
            ],
            null,
            true
        );
        if (function_exists('wp_set_script_translations')) {
            wp_set_script_translations('shepa_gateway-blocks-integration');
        }
        return ['shepa_gateway-blocks-integration'];
    }

    public function get_payment_method_data()
    {
        return [
            'title' => $this->gateway->title,
            'description' => $this->gateway->description,
            'img' => $this->gateway->get_icon_url()
        ];
    }
}
